
##################################################
# Complement to luc.tcl
#
# luciole ad hoc nodes (i.e. not simple ptk ones)
#
##################################################

#----------------------------------------------------------
# toggle
# toggle
# single param expected:
# - vname for luc::InputVars($vname) OR luc::OutputVars($vname)
#   dependiong on VarPin
#----------------------------------------------------------
proc luc::begin_toggle { dummy zevar args } {
	#$dummy=switch
	luc::DBG "luc::begin_toggle $zevar $args"
	set opts $args
	# type check
	luc::ASSERT [expr { $luc::VarType($zevar) == "bool" } ] \
		"toggle: expect bool var ($zevar is $luc::VarType($zevar))"
	switch -glob $luc::VarPin($zevar) {
		"in" {
			ptk::begin toggle luc::InputVars($zevar)
		}
		"out" {
			ptk::begin toggle luc::OutputVars($zevar)
		}
		default {
			luc::Error "luc::begin_toggle unexpected var pin '$luc::VarPin($zevar)')"
		}
	}
}
proc luc::end_toggle { dummy } {
	ptk::end toggle
}

proc luc::begin_switch { dummy zevar zevals args } {
	#$dummy=switch
	luc::DBG "luc::begin_switch $zevar $args"
	set opts $args
	# no type check at all ... 
	switch -glob $luc::VarPin($zevar) {
		"in" {
			ptk::begin switch luc::InputVars($zevar) $zevals
		}
		"out" {
			ptk::begin switch luc::OutputVars($zevar) $zevals
		}
		default {
			luc::Error "luc::begin_switch unexpected var pin '$luc::VarPin($zevar)')"
		}
	}
}
proc luc::end_switch { dummy } {
	ptk::end switch
}
