
##################################################
# Complement to luc.tcl
#
# luciole ad hoc leaves (i.e. not simple ptk ones)
#
##################################################

#luc::decl_leaf "inbool" {var} "luc::inbool" "luc::configure_inbool"
#luc::decl_leaf "outbool" {var} "luc::outbool" "luc::configure_outbool"
#luc::decl_leaf "outvar" {var} "luc::outvar" "luc::configure_outvar"

#----------------------------------------------------------
# Classical inbool:
# - a button set+step
# - a checkbutton set/unset
# - within a 'toggle' commanded by 'auto-step' var

# single param expected:
# - vname for luc::InputVars($vname)
# - NO opts for now (TODO ?)
#----------------------------------------------------------
proc luc::inbool { zevar args } {
	luc::DBG "luc::inbool $zevar $args"
	set opts $args
	# type check
	luc::ASSERT [expr { $luc::VarType($zevar) == "bool" } ] \
		"inbool: expect bool var ($zevar is $luc::VarType($zevar))"
	# label ?
	set lbl [ luc::GetVarAttr $zevar "-label" $zevar ]
	ptk::begin toggle luc::Global(auto_step)
		ptk::add button -text "$lbl" \
			-command "luc::TreatBI $zevar"
		ptk::add checkbutton -text "$lbl" \
			-variable luc::InputVars($zevar)
	ptk::end toggle
}

proc luc::TreatBI { zevar } {
	luc::DBG "luc::TreatBI $zevar"
	#set var
	set luc::InputVars($zevar) 1
	#call a step of the reactive program
	luc::TreatStep
	#unset the corresponding variable
	set luc::InputVars($zevar) 0
}

#----------------------------------------------------------
# Classical outbool:
# - a grey label
# - a red label
# - within a toggle commanded by zevar 
#----------------------------------------------------------

proc luc::outbool { zevar args } {
	luc::DBG "luc::outbool $zevar $args"
	set opts $args
	# type check
	luc::ASSERT [expr { $luc::VarType($zevar) == "bool" } ] \
		"outbool: expect bool var ($zevar is $luc::VarType($zevar))"
	# label ?
	set lbl [ luc::GetVarAttr $zevar "-label" $zevar ]
	ptk::begin toggle luc::Global(just_reset)
		# grey on grey label
		ptk::add label -text "$lbl" -fg {#cfcfcf} -bg {#efefef}
		ptk::begin toggle luc::OutputVars($zevar)
			# white on red label
			ptk::add label -text "$lbl" -fg {#ffffff} -bg {#ff0000}
			# black on grey label
			#ptk::add label -text "$lbl" -bg {#efefef} -fg {#afafaf}
			ptk::add label -text "$lbl" -fg {#202020} -bg {#efefef}
		ptk::end toggle
	ptk::end toggle
}

#----------------------------------------------------------
# Classical intscale:
#----------------------------------------------------------
proc luc::intscale { zevar args } {
	luc::DBG "luc::intscale $zevar $args"
   set lbl [ luc::GetVarAttr $zevar "-label" "$zevar" ]
   set min [ luc::GetVarAttr $zevar "-min" "-100" ]
   set max [ luc::GetVarAttr $zevar "-max" "100" ]
	ptk::add scale -variable luc::InputVars($zevar) \
		-label "$lbl" -from "$min" -to "$max" \
		-orient {horizontal} -relief {raised}

}
#----------------------------------------------------------
# Classical realscale:
#----------------------------------------------------------
proc luc::realscale { zevar args } {
	luc::DBG "luc::realscale $zevar $args"
   set lbl [ luc::GetVarAttr $zevar "-label" "$zevar" ]
   set min [ luc::GetVarAttr $zevar "-min" "-100.0" ]
   set max [ luc::GetVarAttr $zevar "-max" "100.0" ]
   set step [ luc::GetVarAttr $zevar "-step" "0.1" ]
	ptk::add scale -variable luc::InputVars($zevar) \
		-label "$lbl" -from "$min" -to "$max" -resolution "$step"\
		-orient {horizontal} -relief {raised}
}

proc luc::outvar { zevar args  } {
   luc::DBG "luc::outvar $zevar"
   set lbl [ luc::GetVarAttr "$zevar" "label" $zevar ]
	ptk::begin line -text  "$lbl"
		ptk::begin toggle luc::Global(just_reset)
   		ptk::add label -text "?" \
      		-relief {sunken} \
      		-bg white \
      		-anchor {c}
   		ptk::add label -textvariable luc::OutputVars($zevar) \
      		-relief {sunken} \
      		-anchor {c}
		ptk::end toggle
	ptk::end line
}

