#line 56 "./src/implbla.nw"
class BlaReader;
class STLightItem {
friend class STLight;
protected:
	STLightItem* next;
	const char* son;
	STLightItem(const char* s, STLightItem* n){
		son = s; next = n;	
	}
};
class STLight {
	
#line 81 "./src/implbla.nw"
static const int hash_size = 51;
STLightItem* hash_table[hash_size];
#line 95 "./src/implbla.nw"
int hash_code(const char* nme);
#line 68 "./src/implbla.nw"
public:
	STLight(){
		
#line 86 "./src/implbla.nw"
int i;
for(i = 0; i < hash_size; i++){
	hash_table[i] = (STLightItem*)NULL;
}
#line 71 "./src/implbla.nw"
	}
	
#line 121 "./src/implbla.nw"
const char* find(const char* nme);
const char* add(const char* nme);
#line 73 "./src/implbla.nw"
};
#line 124 "./src/apibla.nw"
enum BlaItem {
	
#line 150 "./src/apibla.nw"
	BLA_EOF,
#line 158 "./src/apibla.nw"
	BLA_INT,
#line 166 "./src/apibla.nw"
	BLA_FLOAT,
#line 174 "./src/apibla.nw"
	BLA_PRAGMA,
#line 182 "./src/apibla.nw"
	BLA_END_PRAGMA,
#line 190 "./src/apibla.nw"
	BLA_STRING,
#line 198 "./src/apibla.nw"
	BLA_ERROR,
#line 126 "./src/apibla.nw"
	NB_BlaItem
};
#line 6 "./src/apibla.nw"
class BlaReader {
	
#line 13 "./src/implbla.nw"
FILE* infile;
int (*infunction)();
#line 157 "./src/implbla.nw"
STLight* pragmas;
#line 177 "./src/implbla.nw"
char buffer[1024];
BlaItem curitem;
#line 189 "./src/implbla.nw"
int cur_char;
#line 196 "./src/implbla.nw"
int get_char_buff_cpt;
int get_char_buff[5];
#line 206 "./src/implbla.nw"
void get_char(){
	if(get_char_buff_cpt){
		cur_char = get_char_buff[--get_char_buff_cpt];
	} else {
		cur_char = (infile)? fgetc(infile) : (*infunction)();
	}
}
#line 215 "./src/implbla.nw"
void unget_and_restore(int c){
	get_char_buff[get_char_buff_cpt++] = cur_char;
	cur_char = c;
}
#line 240 "./src/implbla.nw"
const char* curpragma;
int par_pragma_mode;
int line_pragma_mode;
#line 487 "./src/implbla.nw"
void ignore_line();
void ignore_comment();
#line 8 "./src/apibla.nw"
public:
	
#line 85 "./src/apibla.nw"
const char* version(){ return "1"; }
#line 101 "./src/apibla.nw"
BlaReader(int (*f)());
BlaReader(FILE* in);
BlaReader();
#line 132 "./src/apibla.nw"
const char* item_name(BlaItem it);
#line 210 "./src/apibla.nw"
const char* add_pragma(const char* prag);
#line 221 "./src/apibla.nw"
BlaItem get();
#line 226 "./src/apibla.nw"
BlaItem get(const char** val);
#line 233 "./src/apibla.nw"
BlaItem cur_item();
const char* cur_string();
#line 10 "./src/apibla.nw"
};
#line 48 "./src/apirif.nw"
enum RifItem {
	
#line 75 "./src/apirif.nw"
   RIF_EOF,
#line 82 "./src/apirif.nw"
   RIF_VALUE,
#line 89 "./src/apirif.nw"
   RIF_ERROR,
#line 157 "./src/apirif.nw"
   RIF_PROGRAM,
#line 175 "./src/apirif.nw"
   RIF_RESET,
#line 186 "./src/apirif.nw"
   RIF_STEP,
#line 203 "./src/apirif.nw"
   RIF_INPUTS,
#line 223 "./src/apirif.nw"
   RIF_OUTPUTS,
#line 250 "./src/apirif.nw"
   RIF_LOCALS,
#line 275 "./src/apirif.nw"
   RIF_BEGIN_OUTS,
   RIF_END_OUTS,
   RIF_BEGIN_LOCS,
   RIF_END_LOCS,
#line 50 "./src/apirif.nw"
	NB_RifItem
};
#line 5 "./src/apirif.nw"
class RifReader : public BlaReader {
	
#line 24 "./src/implrif.nw"
const char* vers;
#line 41 "./src/implrif.nw"
char error_buff[1024];
#line 135 "./src/implrif.nw"
const char* reset_pragma;
#line 148 "./src/implrif.nw"
RifItem parse_reset_pragma();
#line 175 "./src/implrif.nw"
const char* program_pragma;
#line 188 "./src/implrif.nw"
const char* pname;
#line 204 "./src/implrif.nw"
RifItem parse_program_pragma();
#line 239 "./src/implrif.nw"
const char* step_pragma;
#line 252 "./src/implrif.nw"
int stepcpt;
#line 268 "./src/implrif.nw"
RifItem parse_step_pragma();
#line 303 "./src/implrif.nw"
STLight* idents;
#line 313 "./src/implrif.nw"
const char* inputs_pragma;
#line 326 "./src/implrif.nw"
int nbins;
const char** innames;
const char** intypes;
#line 351 "./src/implrif.nw"
RifItem parse_inputs_pragma();
#line 434 "./src/implrif.nw"
const char* outputs_pragma;
#line 447 "./src/implrif.nw"
int nbouts;
const char** outnames;
const char** outtypes;
#line 472 "./src/implrif.nw"
RifItem parse_outputs_pragma();
#line 550 "./src/implrif.nw"
const char* outs_pragma;
#line 569 "./src/implrif.nw"
const char* locals_pragma;
#line 582 "./src/implrif.nw"
int nblocs;
const char** locnames;
const char** loctypes;
#line 607 "./src/implrif.nw"
RifItem parse_locals_pragma();
#line 685 "./src/implrif.nw"
const char* locs_pragma;
#line 7 "./src/apirif.nw"
public:
	
#line 24 "./src/apirif.nw"
const char* rif_version() { return "0"; }
const char* version();
#line 33 "./src/apirif.nw"
RifReader();
RifReader(FILE* inf);
RifReader(int (*f)() );
#line 44 "./src/apirif.nw"
RifItem get();
#line 56 "./src/apirif.nw"
const char* item_name(RifItem it);
#line 99 "./src/apirif.nw"
const char* error_msg();
#line 106 "./src/apirif.nw"
const char* cur_value();
#line 117 "./src/apirif.nw"
int is_bool_value(const char* v);
int is_bool_value(const char* v, int* res);
#line 123 "./src/apirif.nw"
int is_int_value(const char* v);
int is_int_value(const char* v, long* res);
#line 129 "./src/apirif.nw"
int is_real_value(const char* v);
int is_real_value(const char* v, double* res);
#line 137 "./src/apirif.nw"
int is_bottom_value(const char* v);
#line 154 "./src/apirif.nw"
void add_program_pragma();
#line 165 "./src/apirif.nw"
const char* program_name();
#line 172 "./src/apirif.nw"
void add_reset_pragma();
#line 183 "./src/apirif.nw"
void add_step_pragma();
#line 194 "./src/apirif.nw"
int step();
#line 200 "./src/apirif.nw"
void add_inputs_pragma();
#line 211 "./src/apirif.nw"
int nb_inputs();
const char* input_name(int i);
const char* input_type(int i);
#line 219 "./src/apirif.nw"
void add_outputs_pragma();
#line 231 "./src/apirif.nw"
int nb_outputs();
const char* output_name(int i);
const char* output_type(int i);
#line 239 "./src/apirif.nw"
void add_outs_pragma();
#line 246 "./src/apirif.nw"
void add_locals_pragma();
#line 258 "./src/apirif.nw"
int nb_locals();
const char* local_name(int i);
const char* local_type(int i);
#line 266 "./src/apirif.nw"
void add_locs_pragma();
#line 9 "./src/apirif.nw"
};
