import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.io.Reader;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.Writer;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

class Quine {
    final static Pattern CLASS_DECL = Pattern.compile("^(public\\s+)?class\\s+(\\p{Alnum}+)\\s*\\{$");

    static void makeSubClass(BufferedReader in, Writer out, String newName) throws IOException {
	while(true) {
	    String line = in.readLine();
	    if (line == null) break;
	    Matcher matcher = CLASS_DECL.matcher(line);
	    if (matcher.matches()) {
		out.write("  static class " + newName + " {\n");
	    } else {
		out.write("  " + line + "\n");
	    }
	}
    }

    static void makeSubClass(String in, Writer out, String newName) throws IOException {
	makeSubClass(new BufferedReader(new StringReader(in)), out, newName);
    }

    static String compose(String first, String second) {
	try {
	    StringWriter out = new StringWriter();
	    out.write("class Composed {\n");
	    makeSubClass(first, out, "First");
	    makeSubClass(second, out, "Second");
	    out.write("  public static String run(final String x) {\n    return First.run(Second.run(x));\n  }\n}\n");
	    String s = out.toString();
	    out.close();
	    return s;
	} catch (IOException exn) {
	    throw new RuntimeException("Quine compose", exn);
	}
    }

    static String snm(String program, int m, int n, String[] args) {
	if (m > n || args.length != m) {
	    throw new RuntimeException("snm compose bad lengths");
	}
	try {
	    StringWriter out = new StringWriter();
	    out.write("class Snm {\n");
	    makeSubClass(program, out, "Inside");
	    out.write("  public static String run(");
	    for(int j=1; j<=n; j++) {
		if (j > 1) out.write(", ");
		out.write("final String " + "y" + j);
	    }
	    out.write(") {\n");
	    out.write("    return Inside.run(\n");
	    for(int i=0; i<m; i++) {
		out.write("      \"");
		JavaUtil.writeEscaped(out, args[i]);
		out.write("\"");
		if (i<m-1 || n>0) out.write(",\n");
	    }
	    out.write("      ");
	    for(int j=1; j<=n; j++) {
		out.write("y" + j);
		if (j<n) out.write(", ");
	    }
	    out.write(");\n  }\n}");
	    return out.toString();
	} catch (IOException exn) {
	    throw new RuntimeException("Quine snm", exn);
	}	
    }

    static String readFile(String filename) throws IOException {
	BufferedReader reader = new BufferedReader(new FileReader(filename));
	StringBuilder builder = new StringBuilder();
	while (true) {
	    String line = reader.readLine();
	    if (line==null) break;
	    builder.append(line);
	    builder.append('\n');
	}
	return builder.toString();
    }

    public static void main(String[] args) throws IOException {
	String first = readFile("Totoro.java");
	//String second = readFile("Second.java");
	System.out.print(snm(first, 1, 1, new String[] { "A\\" }));
    }
}