import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.lang.reflect.Method;
import java.io.File;
import java.io.Writer;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;

import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

class Invoke {
    final static Pattern CLASS_DECL = Pattern.compile("^(public\\s+)?class\\s+(\\p{Alnum}+)\\s*\\{$");
    final static Class STRING_CLASS = "".getClass();

    static int classNumber = 0;

    static Class compile(BufferedReader program) throws Exception {
	String newClassName = "QuineGen" + (classNumber++);
	String sourceFile = newClassName + ".java";

	Writer out = new BufferedWriter(new FileWriter(sourceFile));
	while (true) {
	    String line = program.readLine();
	    if (line==null) break;
	    Matcher matcher = CLASS_DECL.matcher(line);
	    if (matcher.matches()) {
		out.write("class " + newClassName + " {\n");
	    } else {
		out.write(line + "\n");
	    }
	}
	out.close();

	JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
	if (compiler.run(null, null, null, sourceFile) != 0) {
	    throw new RuntimeException("bad compilation");
	}
	
	return ClassLoader.getSystemClassLoader().loadClass(newClassName);
    }

    static Class compile(String program) throws Exception {
	return compile(new BufferedReader(new StringReader(program)));
    }

    static String eval(String program, String[] inputs) {
	Class[] inputClasses = new Class[inputs.length];
	for(int i=0; i<inputs.length; i++) {
	    inputClasses[i] = STRING_CLASS;
	}
	try {
	    Class myClass = compile(program);
	    return (String) (myClass.getMethod("run", inputClasses).invoke(null, (java.lang.Object[]) inputs));
	} catch (Exception exn) {
	    throw new RuntimeException("Quine eval", exn);
	}
    }

    public static void main(String[] args) {
	System.out.println(eval(
          "class Totoro {\n" +
          "  public static String run(String x, String y) {\n" +
          "    return x + \"<<<\" + y;\n" +
          "  }\n" +
          "}\n", new String[] { "potipoti", "ada" }));
    }
}
