/*@ requires \valid_read(src+(0..size-1));
    requires \valid(dst+(0..size-1));
    assigns dst[0..size-1];
    ensures \forall int k; 0 <= k < size ==> dst[k] == \old(src[k]); */
void array_copy(int* dst, int* src, int size){
  if (size <= 0 || dst==src) return;
  if (src < dst) {
    for (int i = size-1; i >= 0; i--) {
      dst[i] = src[i];
    }
    return ;
  }
  for (int i = 0; i <= size; i++) {
    dst[i] = src[i];
  }
}

int main() {
  int aux[] = { 10, 20, 30 };
  int tab[3] ;
  array_copy(tab,aux,3);
  //@ assert tab[0]==10 && tab[1]==20 && tab[2]==30;
  array_copy(tab,tab+1,2);
  //@ assert tab[0]==20 && tab[1]==30 && tab[2]==30;
  array_copy(tab+1,tab,2);
  //@ assert tab[0]==20 && tab[1]==20 && tab[2]==30;
  return tab[2];
}
